/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSyncTradesPacket {
    private final int containerId;
    public final MerchantOffers offers;
    private final int villagerLevel;
    private final int villagerXp;
    private final boolean showProgress;
    private final boolean canRestock;

    public ClientBoundSyncTradesPacket(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        this.offers = MerchantOffers.m_45395_((FriendlyByteBuf)buf);
        this.villagerLevel = buf.m_130242_();
        this.villagerXp = buf.m_130242_();
        this.showProgress = buf.readBoolean();
        this.canRestock = buf.readBoolean();
    }

    public ClientBoundSyncTradesPacket(int id, MerchantOffers offers, int level, int villagerXp, boolean showProgress, boolean canRestock) {
        this.containerId = id;
        this.offers = offers;
        this.villagerLevel = level;
        this.villagerXp = villagerXp;
        this.showProgress = showProgress;
        this.canRestock = canRestock;
    }

    public static void buffer(ClientBoundSyncTradesPacket message, FriendlyByteBuf buf) {
        buf.m_130130_(message.containerId);
        message.offers.m_45393_(buf);
        buf.m_130130_(message.villagerLevel);
        buf.m_130130_(message.villagerXp);
        buf.writeBoolean(message.showProgress);
        buf.writeBoolean(message.canRestock);
    }

    public static void handler(ClientBoundSyncTradesPacket message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                ClientReceivers.handleSyncTradesPacket(message);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getVillagerLevel() {
        return this.villagerLevel;
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public MerchantOffers getOffers() {
        return this.offers;
    }

    public boolean isCanRestock() {
        return this.canRestock;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }
}

